<?php
class Film {
    
    private $titre;
    private $resume;
    private $dateSortie;
    private $realisateurs;
    private $acteurs;
    
	// Constructeur
    public function __construct(string $titre, string $resume, string $dateSortie, array $realisateurs, array $acteurs) {
        $this->titre = $titre;
        $this->resume = $resume;
        $this->dateSortie = $dateSortie;
        $this->realisateurs = $realisateurs;
        $this->acteurs = $acteurs;
    }
    
	// Getters
    public function getTitre() : string {
        return $this->titre;
    }
    
    public function getResume() : string {
        return $this->resume;
    }

    public function getDateSortie() : string {
        return $this->dateSortie;
    }
    
    public function getRealisateurs() : array {
        return $this->realisateurs;
    }
    
    public function getActeurs() : array {
        return $this->acteurs;
    }

	// Setters
    public function setTitre(string $titre) : void {
        $this->titre = $titre;
    }
    
    public function setResume(string $resume) : void {
        $this->resume = $resume;
    }
    
    public function setDateSortie(string $dateSortie) : void {
        $this->dateSortie = $dateSortie;
    }
    
    public function setRealisateurs(array $realisateurs) : void {
        $this->realisateurs = $realisateurs;
    }

    public function setActeurs(array $acteurs) : void {
        $this->acteurs = $acteurs;
    }

	// Méthode __toString
    public function __toString() : string {
        $result = "<b>{$this->titre}</b> ({$this->dateSortie})<br/><i>{$this->resume}</i><br/>Réalisateurs : ";
        for($i = 0; $i < count($this->realisateurs); $i++) {
            $result .= $this->realisateurs[$i]." ; ";
        }
        $result .= "<br/>Acteurs : ";
        for($i = 0; $i < count($this->acteurs); $i++) {
            $result .= $this->acteurs[$i]." ; ";
        }
        
        return $result;
    }

}
